<?php
/**
 * index.php — TVPremiumPro mailer
 * - Sends a "thank you" email to the client (no codes yet)
 * - Sends a sale notification to admin
 * - TVPremiumPro-only (no other brands)
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require './PHPMailer/src/Exception.php';
require './PHPMailer/src/PHPMailer.php';
require './PHPMailer/src/SMTP.php';

/* ===================== TVPremiumPro CONFIG ===================== */
$SITE_NAME      = 'TVPremiumPro';
$SITE_URL       = 'https://tvpremiumpro.com/';
$WHATSAPP_DIGIT = '33756755897'; // +33 7 56 75 58 97 -> digits only for wa.me
$WHATSAPP_URL   = 'https://wa.me/' . $WHATSAPP_DIGIT;

$SMTP = [
  'host'   => 'tvpluxi.com',          // TODO: use your TVPremiumPro SMTP if different
  'user'   => 'support@tvpluxi.com',  // TODO: replace
  'pass'   => 'wdrdxM0Jk+nI',         // TODO: replace
  'secure' => 'ssl',                   // 'ssl' or 'tls'
  'port'   => 465,
];

$FROM_EMAIL   = 'support@tvpluxi.com';       // sender
$FROM_NAME    = 'TVPremiumPro Support';      // sender name
$REPLY_TO     = ['email' => 'support@tvpluxi.com', 'name' => 'TVPremiumPro Support'];

// Admin who receives sale notifications:
$ADMIN_EMAIL  = 'aidihamid461@gmail.com';       // TODO: set to your inbox
$ADMIN_NAME   = 'TVPremiumPro';

/* ===================== HELPERS ===================== */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function clean($v){ return trim(strip_tags((string)$v)); }
function make_mailer(array $SMTP, string $fromEmail, string $fromName, array $replyTo): PHPMailer {
  $m = new PHPMailer(true);
  // UTF-8 safe
  mb_internal_encoding('UTF-8');
  $m->CharSet  = 'UTF-8';
  $m->Encoding = 'base64';

  $m->isSMTP();
  $m->Host       = $SMTP['host'];
  $m->SMTPAuth   = true;
  $m->Username   = $SMTP['user'];
  $m->Password   = $SMTP['pass'];
  $m->SMTPSecure = $SMTP['secure'];
  $m->Port       = $SMTP['port'];

  $m->setFrom($fromEmail, $fromName);
  $m->addReplyTo($replyTo['email'], $replyTo['name']);
  $m->isHTML(true);
  return $m;
}

/* ===================== EMAIL TEMPLATES ===================== */
/** Client “Thank you” HTML (NO CODES YET) */
function tpl_client_thanks(string $siteName, string $siteUrl, string $whatsUrl, string $toEmail, string $plan='', string $amount='', string $duration=''): string {
  $email    = h($toEmail);
  $planTxt  = $plan    ? '<span class="pill">Plan : '.h($plan).'</span>' : '';
  $amtTxt   = $amount  ? '<span class="pill">Total : '.h($amount).'€</span>' : '';
  $durTxt   = $duration? '<span class="pill">Durée : '.h($duration).'</span>' : '';
  $pills    = trim($planTxt.$amtTxt.$durTxt) ? "<div class=\"pillrow\">$planTxt $amtTxt $durTxt</div>" : '';

  return <<<HTML
<!doctype html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="x-apple-disable-message-reformatting">
  <meta name="format-detection" content="telephone=no,address=no,email=no,date=no,url=no">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    body{margin:0;padding:0;background:#f4f7fa;font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,Arial}
    .wrap{max-width:640px;margin:32px auto;background:#fff;border:1px solid #e5e8f0;border-radius:14px;box-shadow:0 8px 24px rgba(16,24,40,.08);overflow:hidden}
    .hdr{background:linear-gradient(90deg,#4DA3FF,#0056B3);padding:24px 28px;text-align:center;color:#fff}
    .hdr h1{margin:0;font-size:24px;font-weight:700}
    .in{padding:26px 28px;color:#0f172a}
    p{margin:0 0 14px 0;line-height:1.55}
    .pillrow{margin:10px 0 6px 0}
    .pill{display:inline-block;background:#f1f5f9;color:#334155;border-radius:999px;padding:6px 10px;font-size:12px;margin-right:6px;margin-bottom:6px}
    .cta{margin-top:18px;text-align:center}
    .btn{display:inline-block;background:linear-gradient(90deg,#4DA3FF,#0056B3);color:#fff;text-decoration:none;padding:12px 18px;border-radius:10px;font-weight:700}
    .subbtn{display:inline-block;margin-left:8px;border:1px solid #e5e7eb;border-radius:10px;padding:11px 16px;color:#0f172a;text-decoration:none}
    .ft{border-top:1px solid #eef2f7;margin-top:18px;padding-top:16px;font-size:12px;color:#64748b;text-align:center}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="hdr">
      <h1>🎉 Merci pour votre achat — {$siteName}</h1>
    </div>
    <div class="in">
      <p>Bonjour <strong>{$email}</strong>,</p>
      <p>Merci pour votre commande chez <strong>{$siteName}</strong> !</p>
      <p>Votre paiement est bien reçu. <strong>Vous recevrez votre code d’activation par email dans quelques minutes</strong>.</p>
      {$pills}
      <div class="cta">
        <a class="btn" href="{$whatsUrl}" target="_blank" rel="noopener">💬 Besoin d’aide ? WhatsApp</a>
        <a class="subbtn" href="{$siteUrl}" target="_blank" rel="noopener">⟵ Retour au site</a>
      </div>
      <p style="margin-top:16px;font-size:13px;color:#475569">Astuce : vérifiez aussi votre dossier <em>Spam</em> si vous ne voyez rien après 5 minutes.</p>
      <div class="ft">© 2025 {$siteName}</div>
    </div>
  </div>
</body>
</html>
HTML;
}

/** Admin notification (simple HTML) */
function tpl_admin_notice(string $siteName, string $toEmail, string $plan='', string $amount='', string $duration='', string $price='', string $notes=''): string {
  $rows = [
    'Client email' => $toEmail,
    'Plan'         => $plan,
    'Amount'       => $amount ? ($amount.' €') : '',
    'Duration'     => $duration,
    'Price'        => $price,
    'Notes'        => $notes,
  ];
  $trs = '';
  foreach ($rows as $k=>$v) {
    if ($v==='') continue;
    $trs .= '<tr><td style="padding:8px 10px;border-bottom:1px solid #eef2f7;color:#334155;">'.h($k).'</td><td style="padding:8px 10px;border-bottom:1px solid #eef2f7;color:#0f172a;font-weight:600">'.h($v).'</td></tr>';
  }

  return <<<HTML
<!doctype html>
<html>
<head><meta charset="UTF-8"></head>
<body style="background:#f8fafc;margin:0;padding:20px;font-family:Arial,Helvetica,sans-serif">
  <div style="max-width:680px;margin:auto;background:#fff;border:1px solid #e5e7eb;border-radius:12px;overflow:hidden">
    <div style="background:#0b63c7;color:#fff;padding:16px 18px;font-weight:700">🛒 Nouvelle vente — {$siteName}</div>
    <div style="padding:16px 18px">
      <table width="100%" cellspacing="0" cellpadding="0" style="border-collapse:collapse">{$trs}</table>
      <p style="font-size:12px;color:#64748b;margin-top:10px">Notification automatique {$siteName}.</p>
    </div>
  </div>
</body>
</html>
HTML;
}

/* ===================== MAIN ===================== */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo 'Method Not Allowed';
  exit;
}

// Inputs
$email    = clean($_POST['email'] ?? '');
$plan     = clean($_POST['plan'] ?? '');      // optional
$amount   = clean($_POST['amount'] ?? '');    // optional (e.g., "39.99")
$duration = clean($_POST['duration'] ?? '');  // optional
$price    = clean($_POST['price'] ?? '');     // optional
$notes    = clean($_POST['notes'] ?? '');     // optional free text

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  http_response_code(400);
  echo 'Invalid email';
  exit;
}

try {
  // 1) CLIENT EMAIL
  $clientMailer = make_mailer($SMTP, $FROM_EMAIL, $FROM_NAME, $REPLY_TO);
  $clientMailer->addAddress($email);
  $clientMailer->Subject = "{$SITE_NAME} — Merci pour votre achat";
  $clientMailer->Body    = tpl_client_thanks($SITE_NAME, $SITE_URL, $WHATSAPP_URL, $email, $plan, $amount, $duration);
  $clientMailer->send();

  // 2) ADMIN EMAIL (best-effort — do not fail the request if this one errors)
  try {
    $adminMailer = make_mailer($SMTP, $FROM_EMAIL, $FROM_NAME, $REPLY_TO);
    $adminMailer->addAddress($ADMIN_EMAIL, $ADMIN_NAME);
    $adminMailer->Subject = "Nouvelle vente — {$SITE_NAME}";
    $adminMailer->Body    = tpl_admin_notice($SITE_NAME, $email, $plan, $amount, $duration, $price, $notes);
    $adminMailer->send();
  } catch (\Throwable $e) {
    // ignore admin mail failures
  }

  // Optional: insert minimal row to your DB if you want
  // (commented out — add your own DB logic here)
  /*
  $pdo = new PDO('mysql:host=...;dbname=...;charset=utf8mb4','user','pass',[PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
  $stmt = $pdo->prepare("INSERT INTO sales(email, plan, amount, duration, price, notes, created_at) VALUES(?,?,?,?,?,?,NOW())");
  $stmt->execute([$email,$plan,$amount,$duration,$price,$notes]);
  */

  // Success response
  echo "
  <html><head><meta charset='UTF-8'>
  <style>
    body{font-family:Arial, sans-serif; background:#f7f7f7; margin:0; padding:0;}
    .container{max-width:600px; margin:50px auto; background:#fff; padding:24px; border-radius:12px; box-shadow:0 8px 24px rgba(16,24,40,.08); border:1px solid #e5e7eb;}
    .title{font-size:20px; font-weight:700; color:#0b63c7; text-align:center; margin-bottom:8px;}
    .p{color:#334155; text-align:center}
    .btns{display:flex; gap:10px; justify-content:center; margin-top:16px}
    .btn{padding:10px 16px; border-radius:10px; text-decoration:none}
    .btn-primary{background:#0b63c7; color:#fff;}
    .btn-outline{border:1px solid #e5e7eb; color:#0f172a;}
  </style></head>
  <body>
    <div class='container'>
      <div class='title'>Merci !</div>
      <p class='p'>Un email de confirmation a été envoyé à <strong>".h($email)."</strong>.<br>Vous recevrez votre code très bientôt.</p>
      <div class='btns'>
        <a class='btn btn-primary' href='".h($WHATSAPP_URL)."' target='_blank' rel='noopener'>WhatsApp</a>
        <a class='btn btn-outline' href='".h($SITE_URL)."' target='_blank' rel='noopener'>Retour au site</a>
      </div>
    </div>
  </body></html>
  ";

} catch (Exception $e) {
  http_response_code(500);
  echo "Mailer error: ".h($e->getMessage());
}
